package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.OS3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * OS3DaoImpl generated by UDA, 28-feb-2017 11:23:12.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class OS3DaoImpl implements OS3Dao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.TEROS3_061 TEROS3061, t1.ANOOS3_061 ANOOS3061, t1.NUMOS3_061 NUMOS3061, t1.FECPRE_061 FECPRE061, t1.FECIER_061 FECIER061, t1.TERAPE_061 TERAPE061, t1.ANOAPE_061 ANOAPE061, t1.NUMAPE_061 NUMAPE061, t1.NUEVA_061 NUEVA061, t1.TIPDOC_061 TIPDOC061, t1.NUMDOC_061 NUMDOC061, t1.NOMEMP_061 NOMEMP061, t1.PAISEMP_061 PAISEMP061, t1.PRVEMP_061 PRVEMP061, t1.MUNEMP_061 MUNEMP061, t1.DMUNEMP_061 DMUNEMP061, t1.DIREMP_061 DIREMP061, t1.CPOEMP_061 CPOEMP061, t1.TLFEMP_061 TLFEMP061, t1.FAXEMP_061 FAXEMP061, t1.EMAEMP_061 EMAEMP061, t1.HTTPEMP_061 HTTPEMP061, t1.CLASCTR_061 CLASCTR061, t1.TRBTOT_061 TRBTOT061, t1.DECLAR_061 DECLAR061, t1.CARDEC_061 CARDEC061, t1.FECEVR_061 FECEVR061, t1.DESRIE_061 DESRIE061, t1.DESACT_061 DESACT061, t1.OBSERV_061 OBSERV061, t1.CODCTR_061 CODCTR061, t1.FECALT_061 FECALT061, t1.USUALT_061 USUALT061, t1.FECMOD_061 FECMOD061, t1.USUMOD_061 USUMOD061, t1.DESCEMP_061 DESCEMP061, t1.DOCCORRECTA_061 DOCCORRECTA061, t1.ESTADO_061 ESTADO061, t1.FORPRE_061 FORPRE061, t1.MIGRADO_061 MIGRADO061, t1.FOLDER_ID_061 FOLDERID061, t1.COD_DATOS_NOTIF_061 CODDATOSNOTIF061, "
			+ "t1.NUMDOCREPRESENTANTE_061 NUMDOCREPRESENTANTE061, t1.TLFREPRESENTANTE_061 TLFREPRESENTANTE061, t1.TIT_REPR_061 TITREPR061, t1.NOMREPRESENTANTE_061 NOMREPRESENTANTE061 ,t1.TIPDOCREPRESENTANTE_061 TIPDOCREPRESENTANTE061, t1.USUARIO_APE_061 USUARIOAPE061, t1.USUARIO_APORT_061 USUARIOAPORT061, t1.USUARIO_TRAM_061 USUARIOTRAM061, t1.FECREQ_061 FECREQ061, t1.FECSUB_061 FECSUB061  ";

	private static final String QUERY_SELECT_2 = "SELECT t1.ANOOS3_061 ANOOS3061, t1.NUMOS3_061 NUMOS3061, t1.TEROS3_061 TEROS3061 ";

	private static final String QUERY_SELECT_DATOS_REGISTRO = "SELECT t1.ANOOS3_061 ANOOS3061, t1.NUMOS3_061 NUMOS3061, t1.TEROS3_061 TEROS3061, t1.DESEA_REG_061 DESEAREG061, t1.NUM_REGISTRO_061 NUMREGISTRO061, t1.FEC_REGISTRO_061 FECREGISTRO061";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<OS3> rwMap = new RowMapper<OS3>() {
		public OS3 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new OS3(resultSet.getString("TEROS3061"),
					resultSet.getString("ANOOS3061"),
					resultSet.getInt("NUMOS3061"),
					resultSet.getTimestamp("FECPRE061"),
					resultSet.getDate("FECIER061"),
					resultSet.getString("TERAPE061"),
					resultSet.getString("ANOAPE061"),
					resultSet.getInt("NUMAPE061"),
					resultSet.getString("NUEVA061"),
					resultSet.getString("TIPDOC061"),
					resultSet.getString("NUMDOC061"),
					resultSet.getString("NOMEMP061"),
					resultSet.getString("PAISEMP061"),
					resultSet.getString("PRVEMP061"),
					resultSet.getString("MUNEMP061"),
					resultSet.getString("DMUNEMP061"),
					resultSet.getString("DIREMP061"),
					resultSet.getString("CPOEMP061"),
					resultSet.getString("TLFEMP061"),
					resultSet.getString("FAXEMP061"),
					resultSet.getString("EMAEMP061"),
					resultSet.getString("HTTPEMP061"),
					resultSet.getString("CLASCTR061"),
					resultSet.getLong("TRBTOT061"),
					resultSet.getString("DECLAR061"),
					resultSet.getString("CARDEC061"),
					resultSet.getDate("FECEVR061"),
					resultSet.getString("DESRIE061"),
					resultSet.getString("DESACT061"),
					resultSet.getString("OBSERV061"),
					resultSet.getInt("CODCTR061"),
					resultSet.getDate("FECALT061"),
					resultSet.getString("USUALT061"),
					resultSet.getDate("FECMOD061"),
					resultSet.getString("USUMOD061"),
					resultSet.getString("DESCEMP061"),
					resultSet.getString("DOCCORRECTA061"),
					resultSet.getString("ESTADO061"),
					resultSet.getString("FORPRE061"),
					resultSet.getString("MIGRADO061"),
					resultSet.getString("FOLDERID061"),
					resultSet.getString("CODDATOSNOTIF061"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF061")),
					resultSet.getString("NUMDOCREPRESENTANTE061"),
					resultSet.getString("TLFREPRESENTANTE061"),
					resultSet.getString("TITREPR061"),
					resultSet.getString("NOMREPRESENTANTE061"),
					resultSet.getString("TIPDOCREPRESENTANTE061"),
					resultSet.getString("USUARIOAPE061"),
					resultSet.getString("USUARIOAPORT061"),
					resultSet.getString("USUARIOTRAM061"),
					resultSet.getDate("FECSUB061"),
					resultSet.getDate("FECREQ061"));
		}
	};

	private RowMapper<OS3> rwMapPK = new RowMapper<OS3>() {
		public OS3 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new OS3(resultSet.getString("TEROS3061"),
					resultSet.getString("ANOOS3061"),
					resultSet.getInt("NUMOS3061"));
		}
	};

	private RowMapper<OS3> rwMapDatosRegistro = new RowMapper<OS3>() {
		public OS3 mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			OS3 os3 = new OS3(resultSet.getString("TEROS3061"),
					resultSet.getString("ANOOS3061"),
					resultSet.getInt("NUMOS3061"));

			os3.setDeseaRegistrar061(resultSet.getString("DESEAREG061"));
			os3.setNumReg061(resultSet.getString("NUMREGISTRO061"));
			os3.setFecReg061(resultSet.getDate("FECREGISTRO061"));

			return os3;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * dataSource DataSource
	 */
	private RowMapper<JerarquiaDto<OS3>> rwMapJerarquia = new RowMapper<JerarquiaDto<OS3>>() {
		public JerarquiaDto<OS3> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			OS3 ab0461s00 = new OS3(resultSet.getString("TEROS3061"),
					resultSet.getString("ANOOS3061"),
					resultSet.getInt("NUMOS3061"),
					resultSet.getDate("FECPRE061"),
					resultSet.getDate("FECIER061"),
					resultSet.getString("TERAPE061"),
					resultSet.getString("ANOAPE061"),
					resultSet.getInt("NUMAPE061"),
					resultSet.getString("NUEVA061"),
					resultSet.getString("TIPDOC061"),
					resultSet.getString("NUMDOC061"),
					resultSet.getString("NOMEMP061"),
					resultSet.getString("PAISEMP061"),
					resultSet.getString("PRVEMP061"),
					resultSet.getString("MUNEMP061"),
					resultSet.getString("DMUNEMP061"),
					resultSet.getString("DIREMP061"),
					resultSet.getString("CPOEMP061"),
					resultSet.getString("TLFEMP061"),
					resultSet.getString("FAXEMP061"),
					resultSet.getString("EMAEMP061"),
					resultSet.getString("HTTPEMP061"),
					resultSet.getString("CLASCTR061"),
					resultSet.getLong("TRBTOT061"),
					resultSet.getString("DECLAR061"),
					resultSet.getString("CARDEC061"),
					resultSet.getDate("FECEVR061"),
					resultSet.getString("DESRIE061"),
					resultSet.getString("DESACT061"),
					resultSet.getString("OBSERV061"),
					resultSet.getInt("CODCTR061"),
					resultSet.getDate("FECALT061"),
					resultSet.getString("USUALT061"),
					resultSet.getDate("FECMOD061"),
					resultSet.getString("USUMOD061"),
					resultSet.getString("DESCEMP061"),
					resultSet.getString("DOCCORRECTA061"),
					resultSet.getString("ESTADO061"),
					resultSet.getString("FORPRE061"),
					resultSet.getString("MIGRADO061"),
					resultSet.getString("FOLDERID061"),
					resultSet.getString("CODDATOSNOTIF061"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF061")),
					resultSet.getString("NUMDOCREPRESENTANTE061"),
					resultSet.getString("TLFREPRESENTANTE061"),
					resultSet.getString("TITREPR061"),
					resultSet.getString("NOMREPRESENTANTE061"),
					resultSet.getString("TIPDOCREPRESENTANTE061"),
					resultSet.getString("USUARIOAPE061"),
					resultSet.getString("USUARIOAPORT061"),
					resultSet.getString("USUARIOTRAM061"),
					resultSet.getDate("FECSUB061"),
					resultSet.getDate("FECREQ061"));

			JerarquiaDto<OS3> jerarquia = new JerarquiaDto<OS3>();
			jerarquia.setModel(ab0461s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(
					Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(
					Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the os3
	 */
	public OS3 add(OS3 ab0461s00) {
		String query = "INSERT INTO AB0461S00 (TEROS3_061, ANOOS3_061, NUMOS3_061, FECPRE_061, FECIER_061, TERAPE_061, ANOAPE_061, NUMAPE_061, NUEVA_061, TIPDOC_061, NUMDOC_061, NOMEMP_061, PAISEMP_061, PRVEMP_061, MUNEMP_061, DMUNEMP_061, DIREMP_061, CPOEMP_061, TLFEMP_061, FAXEMP_061, EMAEMP_061, HTTPEMP_061, CLASCTR_061, TRBTOT_061, DECLAR_061, CARDEC_061, FECEVR_061, DESRIE_061, DESACT_061, OBSERV_061, CODCTR_061, FECALT_061, USUALT_061, FECMOD_061, USUMOD_061, DESCEMP_061, DOCCORRECTA_061, ESTADO_061, FORPRE_061, MIGRADO_061, FOLDER_ID_061, COD_DATOS_NOTIF_061,NUMDOCREPRESENTANTE_061,TLFREPRESENTANTE_061,TIT_REPR_061,NOMREPRESENTANTE_061,TIPDOCREPRESENTANTE_061) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ab0461s00.getTeros3061(),
				ab0461s00.getAnoos3061(), ab0461s00.getNumos3061(),
				ab0461s00.getFecpre061(), ab0461s00.getFecier061(),
				ab0461s00.getTerape061(), ab0461s00.getAnoape061(),
				ab0461s00.getNumape061(), ab0461s00.getNueva061(),
				ab0461s00.getTipdoc061(), ab0461s00.getNumdoc061(),
				ab0461s00.getNomemp061(), ab0461s00.getPaisemp061(),
				ab0461s00.getPrvemp061(), ab0461s00.getMunemp061(),
				ab0461s00.getDmunemp061(), ab0461s00.getDiremp061(),
				ab0461s00.getCpoemp061(), ab0461s00.getTlfemp061(),
				ab0461s00.getFaxemp061(), ab0461s00.getEmaemp061(),
				ab0461s00.getHttpemp061(), ab0461s00.getClasctr061(),
				ab0461s00.getTrbtot061(), ab0461s00.getDeclar061(),
				ab0461s00.getCardec061(), ab0461s00.getFecevr061(),
				ab0461s00.getDesrie061(), ab0461s00.getDesact061(),
				ab0461s00.getObserv061(), ab0461s00.getCodctr061(),
				ab0461s00.getFecalt061(), ab0461s00.getUsualt061(),
				ab0461s00.getFecmod061(), ab0461s00.getUsumod061(),
				ab0461s00.getDescemp061(), ab0461s00.getDoccorrecta061(),
				ab0461s00.getEstado061(), ab0461s00.getForpre061(),
				ab0461s00.getMigrado061(), ab0461s00.getFolderId061(),
				ab0461s00.getCoddatosnotif061(),
				ab0461s00.getNumdocrepresentante061(),
				ab0461s00.getTlfrepresentante061(), "T",
				ab0461s00.getNomrepresentante061(),
				ab0461s00.getTipdocrepresentante061());
		return ab0461s00;
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the os3
	 */
	public OS3 update(OS3 ab0461s00) {
		String query = "UPDATE AB0461S00 SET FECPRE_061=?, FECIER_061=?, TERAPE_061=?, ANOAPE_061=?, NUMAPE_061=?, NUEVA_061=?, TIPDOC_061=?, NUMDOC_061=?, NOMEMP_061=?, PAISEMP_061=?, PRVEMP_061=?, MUNEMP_061=?, DMUNEMP_061=?, DIREMP_061=?, CPOEMP_061=?, TLFEMP_061=?, FAXEMP_061=?, EMAEMP_061=?, HTTPEMP_061=?, CLASCTR_061=?, TRBTOT_061=?, DECLAR_061=?, CARDEC_061=?, FECEVR_061=?, DESRIE_061=?, DESACT_061=?, OBSERV_061=?, CODCTR_061=?, FECALT_061=?, USUALT_061=?, FECMOD_061=?, USUMOD_061=?, DESCEMP_061=?, DOCCORRECTA_061=?, ESTADO_061=?, FORPRE_061=?, MIGRADO_061=?, FOLDER_ID_061=?, COD_DATOS_NOTIF_061=?,NUMDOCREPRESENTANTE_061=?,TLFREPRESENTANTE_061=?,TIT_REPR_061=?,NOMREPRESENTANTE_061=?,TIPDOCREPRESENTANTE_061=?, FECSUB_061=?, FECREQ_061=? WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query, ab0461s00.getFecpre061(),
				ab0461s00.getFecier061(), ab0461s00.getTerape061(),
				ab0461s00.getAnoape061(), ab0461s00.getNumape061(),
				ab0461s00.getNueva061(), ab0461s00.getTipdoc061(),
				ab0461s00.getNumdoc061(), ab0461s00.getNomemp061(),
				ab0461s00.getPaisemp061(), ab0461s00.getPrvemp061(),
				ab0461s00.getMunemp061(), ab0461s00.getDmunemp061(),
				ab0461s00.getDiremp061(), ab0461s00.getCpoemp061(),
				ab0461s00.getTlfemp061(), ab0461s00.getFaxemp061(),
				ab0461s00.getEmaemp061(), ab0461s00.getHttpemp061(),
				ab0461s00.getClasctr061(), ab0461s00.getTrbtot061(),
				ab0461s00.getDeclar061(), ab0461s00.getCardec061(),
				ab0461s00.getFecevr061(), ab0461s00.getDesrie061(),
				ab0461s00.getDesact061(), ab0461s00.getObserv061(),
				ab0461s00.getCodctr061(), ab0461s00.getFecalt061(),
				ab0461s00.getUsualt061(), ab0461s00.getFecmod061(),
				ab0461s00.getUsumod061(), ab0461s00.getDescemp061(),
				ab0461s00.getDoccorrecta061(), ab0461s00.getEstado061(),
				ab0461s00.getForpre061(), ab0461s00.getMigrado061(),
				ab0461s00.getFolderId061(), ab0461s00.getCoddatosnotif061(),

				ab0461s00.getNumdocrepresentante061(),
				ab0461s00.getTlfrepresentante061(), ab0461s00.getTitRepr061(),
				ab0461s00.getNomrepresentante061(),
				ab0461s00.getTipdocrepresentante061(), ab0461s00.getFecsub061(),
				ab0461s00.getFecreq061(),

				ab0461s00.getTeros3061(), ab0461s00.getAnoos3061(),
				ab0461s00.getNumos3061());
		return ab0461s00;
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 modificarDatosTabNotificacionOS3(OS3 os3) {
		String query = "UPDATE AB0461S00 SET COD_DATOS_NOTIF_061=?,NUMDOCREPRESENTANTE_061=?,TIPDOCREPRESENTANTE_061=?,NOMREPRESENTANTE_061=? WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query,
				os3.getDatosNotificacion().getCodDatosNotif066(),

				os3.getNumdocrepresentante061(),
				os3.getTipdocrepresentante061(), os3.getNomrepresentante061(),

				os3.getTeros3061(), os3.getAnoos3061(), os3.getNumos3061());
		return os3;
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 modificarDatosTabEmpresaOS3(OS3 os3) {
		String query = "UPDATE AB0461S00 SET CODCTR_061=?, NUEVA_061=?, TIPDOC_061=?, NUMDOC_061=?, NOMEMP_061=?, PRVEMP_061=?, MUNEMP_061=?, DIREMP_061=?, CPOEMP_061=?, TLFEMP_061=?, FAXEMP_061=?, TRBTOT_061=?, CLASCTR_061=?, FECEVR_061=?, HTTPEMP_061=?, EMAEMP_061=?, DECLAR_061=?, CARDEC_061=?,TERAPE_061=?, ANOAPE_061=?, NUMAPE_061=? WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query, os3.getCodctr061(), os3.getNueva061(),
				os3.getTipdoc061(), os3.getNumdoc061(), os3.getNomemp061(),
				os3.getPrvemp061(), os3.getMunemp061(), os3.getDiremp061(),
				os3.getCpoemp061(), os3.getTlfemp061(), os3.getFaxemp061(),
				os3.getTrbtot061(), os3.getClasctr061(), os3.getFecevr061(),
				os3.getHttpemp061(), os3.getEmaemp061(), os3.getDeclar061(),
				os3.getCardec061(), os3.getTerape061(), os3.getAnoape061(),
				os3.getNumape061(), os3.getTeros3061(), os3.getAnoos3061(),
				os3.getNumos3061());
		return os3;
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 modificarDatosTabPrevencion(OS3 os3) {
		String query = "UPDATE AB0461S00 SET DESRIE_061=?, DESACT_061=?, OBSERV_061=? WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query, os3.getDesrie061(), os3.getDesact061(),
				os3.getObserv061(), os3.getTeros3061(), os3.getAnoos3061(),
				os3.getNumos3061());
		return os3;
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 modificarDatosTabEstadoOS3(OS3 os3) {
		String query = "UPDATE AB0461S00 SET DOCCORRECTA_061=? WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query,
				os3.getDoccorrecta061() != null ? os3.getDoccorrecta061()
						: Constantes.VALUE_NO,
				os3.getTeros3061(), os3.getAnoos3061(), os3.getNumos3061());
		return os3;
	}

	/**
	 * Finds a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the os3
	 */
	@Transactional(readOnly = true)
	public OS3 find(OS3 ab0461s00) {

		String query = OS3DaoImpl.QUERY_SELECT
				+ " FROM AB0461S00 t1  WHERE t1.TEROS3_061 = ?   AND t1.ANOOS3_061 = ?   AND t1.NUMOS3_061 = ?  ";

		List<OS3> ab0461s00List = this.jdbcTemplate.query(query, this.rwMap,
				ab0461s00.getTeros3061(), ab0461s00.getAnoos3061(),
				ab0461s00.getNumos3061());
		return (OS3) DataAccessUtils.uniqueResult(ab0461s00List);
	}

	/**
	 * Removes a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 */
	public void remove(OS3 ab0461s00) {
		String query = "DELETE FROM AB0461S00 WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query, ab0461s00.getTeros3061(),
				ab0461s00.getAnoos3061(), ab0461s00.getNumos3061());
	}

	/**
	 * Finds a list of rows in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto List<Ab0461s00>
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<OS3> findAll(OS3 ab0461s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(OS3DaoImpl.QUERY_SELECT);

		query.append("FROM AB0461S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0461s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<OS3>) this.jdbcTemplate.query(query.toString(), this.rwMap,
				params.toArray());
	}

	/**
	 * Finds rows in the Ab0461s00 table using like.
	 * 
	 * ab0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0461s00>
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<OS3> findAllLike(OS3 ab0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(OS3DaoImpl.QUERY_SELECT);
		query.append("FROM AB0461S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0461s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<OS3>) this.jdbcTemplate.query(query.toString(), this.rwMap,
				params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Long
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(OS3 ab0461s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0461S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0461s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0461s00 table using like.
	 * 
	 * ab0461s00 Ab0461s00 startsWith Boolean Long
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(OS3 ab0461s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0461S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0461s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0461s00 selected for rup_table.
	 * 
	 * ab0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0461s00>>
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<OS3>> reorderSelection(OS3 ab0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(OS3DaoImpl.QUERY_SELECT);
		// FROM
		query.append("FROM AB0461S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0461s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, OS3.class, filterParamList,
				"TEROS3_061,ANOOS3_061,NUMOS3_061");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<OS3>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0461s00 searchParams Ab0461s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0461s00>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<OS3>> search(OS3 filterParams, OS3 searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(OS3DaoImpl.QUERY_SELECT);
		// FROM
		query.append("FROM AB0461S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, OS3.class, filterParamList, searchSQL,
				searchParamList, from_alias,
				"TEROS3_061,ANOOS3_061,NUMOS3_061");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<OS3>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filterab0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterab0461s00
	 *            the filterab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(OS3 filterab0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(OS3DaoImpl.QUERY_SELECT);
		// FROM
		query.append("FROM AB0461S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0461s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, OS3.class, query,
						params, "TEROS3_061,ANOOS3_061,NUMOS3_061");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto
	 * List<JerarquiaDto<Ab0461s00>>
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<OS3>> findAllLikeJerarquia(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(OS3DaoImpl.QUERY_SELECT);
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0461S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0461S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0461s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "TEROS3_061,ANOOS3_061,NUMOS3_061", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto Long
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0461S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0461S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0461s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "TEROS3_061,ANOOS3_061,NUMOS3_061",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto
	 * List<TableRowDto<Ab0461s00>>
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<OS3>> findAllChild(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB0461S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB0461S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0461s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "TEROS3_061,ANOOS3_061,NUMOS3_061",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<OS3>(this.rwMapPK,
								"TEROS3_061,ANOOS3_061,NUMOS3_061"),
						params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0461s00 entity.
	 * 
	 * ab0461s00 Ab0461s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(OS3 ab0461s00) {

		StringBuilder where = new StringBuilder(OS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0461s00 != null && ab0461s00.getTeros3061() != null) {
			where.append(" AND t1.TEROS3_061 = ?");
			params.add(ab0461s00.getTeros3061());
		}
		if (ab0461s00 != null && ab0461s00.getAnoos3061() != null) {
			where.append(" AND t1.ANOOS3_061 = ?");
			params.add(ab0461s00.getAnoos3061());
		}
		if (ab0461s00 != null && ab0461s00.getNumos3061() != null) {
			where.append(" AND t1.NUMOS3_061 = ?");
			params.add(ab0461s00.getNumos3061());
		}
		if (ab0461s00 != null && ab0461s00.getFecpre061() != null) {
			where.append(" AND t1.FECPRE_061 = ?");
			params.add(ab0461s00.getFecpre061());
		}
		if (ab0461s00 != null && ab0461s00.getFecier061() != null) {
			where.append(" AND t1.FECIER_061 = ?");
			params.add(ab0461s00.getFecier061());
		}
		if (ab0461s00 != null && ab0461s00.getTerape061() != null) {
			where.append(" AND t1.TERAPE_061 = ?");
			params.add(ab0461s00.getTerape061());
		}
		if (ab0461s00 != null && ab0461s00.getAnoape061() != null) {
			where.append(" AND t1.ANOAPE_061 = ?");
			params.add(ab0461s00.getAnoape061());
		}
		if (ab0461s00 != null && ab0461s00.getNumape061() != null) {
			where.append(" AND t1.NUMAPE_061 = ?");
			params.add(ab0461s00.getNumape061());
		}
		if (ab0461s00 != null && ab0461s00.getNueva061() != null) {
			where.append(" AND t1.NUEVA_061 = ?");
			params.add(ab0461s00.getNueva061());
		}
		if (ab0461s00 != null && ab0461s00.getTipdoc061() != null) {
			where.append(" AND t1.TIPDOC_061 = ?");
			params.add(ab0461s00.getTipdoc061());
		}
		if (ab0461s00 != null && ab0461s00.getNumdoc061() != null) {
			where.append(" AND t1.NUMDOC_061 = ?");
			params.add(ab0461s00.getNumdoc061());
		}
		if (ab0461s00 != null && ab0461s00.getNomemp061() != null) {
			where.append(" AND t1.NOMEMP_061 = ?");
			params.add(ab0461s00.getNomemp061());
		}
		if (ab0461s00 != null && ab0461s00.getPaisemp061() != null) {
			where.append(" AND t1.PAISEMP_061 = ?");
			params.add(ab0461s00.getPaisemp061());
		}
		if (ab0461s00 != null && ab0461s00.getPrvemp061() != null) {
			where.append(" AND t1.PRVEMP_061 = ?");
			params.add(ab0461s00.getPrvemp061());
		}
		if (ab0461s00 != null && ab0461s00.getMunemp061() != null) {
			where.append(" AND t1.MUNEMP_061 = ?");
			params.add(ab0461s00.getMunemp061());
		}
		if (ab0461s00 != null && ab0461s00.getDmunemp061() != null) {
			where.append(" AND t1.DMUNEMP_061 = ?");
			params.add(ab0461s00.getDmunemp061());
		}
		if (ab0461s00 != null && ab0461s00.getDiremp061() != null) {
			where.append(" AND t1.DIREMP_061 = ?");
			params.add(ab0461s00.getDiremp061());
		}
		if (ab0461s00 != null && ab0461s00.getCpoemp061() != null) {
			where.append(" AND t1.CPOEMP_061 = ?");
			params.add(ab0461s00.getCpoemp061());
		}
		if (ab0461s00 != null && ab0461s00.getTlfemp061() != null) {
			where.append(" AND t1.TLFEMP_061 = ?");
			params.add(ab0461s00.getTlfemp061());
		}
		if (ab0461s00 != null && ab0461s00.getFaxemp061() != null) {
			where.append(" AND t1.FAXEMP_061 = ?");
			params.add(ab0461s00.getFaxemp061());
		}
		if (ab0461s00 != null && ab0461s00.getEmaemp061() != null) {
			where.append(" AND t1.EMAEMP_061 = ?");
			params.add(ab0461s00.getEmaemp061());
		}
		if (ab0461s00 != null && ab0461s00.getHttpemp061() != null) {
			where.append(" AND t1.HTTPEMP_061 = ?");
			params.add(ab0461s00.getHttpemp061());
		}
		if (ab0461s00 != null && ab0461s00.getClasctr061() != null) {
			where.append(" AND t1.CLASCTR_061 = ?");
			params.add(ab0461s00.getClasctr061());
		}
		if (ab0461s00 != null && ab0461s00.getTrbtot061() != null) {
			where.append(" AND t1.TRBTOT_061 = ?");
			params.add(ab0461s00.getTrbtot061());
		}
		if (ab0461s00 != null && ab0461s00.getDeclar061() != null) {
			where.append(" AND t1.DECLAR_061 = ?");
			params.add(ab0461s00.getDeclar061());
		}
		if (ab0461s00 != null && ab0461s00.getCardec061() != null) {
			where.append(" AND t1.CARDEC_061 = ?");
			params.add(ab0461s00.getCardec061());
		}
		if (ab0461s00 != null && ab0461s00.getFecevr061() != null) {
			where.append(" AND t1.FECEVR_061 = ?");
			params.add(ab0461s00.getFecevr061());
		}
		if (ab0461s00 != null && ab0461s00.getDesrie061() != null) {
			where.append(" AND t1.DESRIE_061 = ?");
			params.add(ab0461s00.getDesrie061());
		}
		if (ab0461s00 != null && ab0461s00.getDesact061() != null) {
			where.append(" AND t1.DESACT_061 = ?");
			params.add(ab0461s00.getDesact061());
		}
		if (ab0461s00 != null && ab0461s00.getObserv061() != null) {
			where.append(" AND t1.OBSERV_061 = ?");
			params.add(ab0461s00.getObserv061());
		}
		if (ab0461s00 != null && ab0461s00.getCodctr061() != null) {
			where.append(" AND t1.CODCTR_061 = ?");
			params.add(ab0461s00.getCodctr061());
		}
		if (ab0461s00 != null && ab0461s00.getFecalt061() != null) {
			where.append(" AND t1.FECALT_061 = ?");
			params.add(ab0461s00.getFecalt061());
		}
		if (ab0461s00 != null && ab0461s00.getUsualt061() != null) {
			where.append(" AND t1.USUALT_061 = ?");
			params.add(ab0461s00.getUsualt061());
		}
		if (ab0461s00 != null && ab0461s00.getFecmod061() != null) {
			where.append(" AND t1.FECMOD_061 = ?");
			params.add(ab0461s00.getFecmod061());
		}
		if (ab0461s00 != null && ab0461s00.getUsumod061() != null) {
			where.append(" AND t1.USUMOD_061 = ?");
			params.add(ab0461s00.getUsumod061());
		}
		if (ab0461s00 != null && ab0461s00.getDescemp061() != null) {
			where.append(" AND t1.DESCEMP_061 = ?");
			params.add(ab0461s00.getDescemp061());
		}
		if (ab0461s00 != null && ab0461s00.getDoccorrecta061() != null) {
			where.append(" AND t1.DOCCORRECTA_061 = ?");
			params.add(ab0461s00.getDoccorrecta061());
		}
		if (ab0461s00 != null && ab0461s00.getEstado061() != null) {
			where.append(" AND t1.ESTADO_061 = ?");
			params.add(ab0461s00.getEstado061());
		}
		if (ab0461s00 != null && ab0461s00.getForpre061() != null) {
			where.append(" AND t1.FORPRE_061 = ?");
			params.add(ab0461s00.getForpre061());
		}

		if (ab0461s00 != null && ab0461s00.getMigrado061() != null) {
			where.append(" AND t1.MIGRADO_061 = ?");
			params.add(ab0461s00.getMigrado061());
		}
		if (ab0461s00 != null && ab0461s00.getFolderId061() != null) {
			where.append(" AND t1.FOLDER_ID_061 = ?");
			params.add(ab0461s00.getFolderId061());
		}
		if (ab0461s00 != null && ab0461s00.getCoddatosnotif061() != null) {
			where.append(" AND t1.COD_DATOS_NOTIF_061 = ?");
			params.add(ab0461s00.getCoddatosnotif061());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0461s00 entity.
	 * 
	 * ab0461s00 Ab0461s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(OS3 ab0461s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(OS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0461s00 != null && ab0461s00.getTeros3061() != null) {
			where.append(" AND UPPER(t1.TEROS3_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getTeros3061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getTeros3061().toUpperCase() + "%");
			}
			where.append(" AND t1.TEROS3_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getAnoos3061() != null) {
			where.append(" AND UPPER(t1.ANOOS3_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getAnoos3061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getAnoos3061().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS3_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getNumos3061() != null) {
			where.append(" AND t1.NUMOS3_061 = ?");
			params.add(ab0461s00.getNumos3061());
		}
		if (ab0461s00 != null && ab0461s00.getFecpre061() != null) {
			where.append(" AND t1.FECPRE_061 = ?");
			params.add(ab0461s00.getFecpre061());
		}
		if (ab0461s00 != null && ab0461s00.getFecier061() != null) {
			where.append(" AND t1.FECIER_061 = ?");
			params.add(ab0461s00.getFecier061());
		}
		if (ab0461s00 != null && ab0461s00.getTerape061() != null) {
			where.append(" AND UPPER(t1.TERAPE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getTerape061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getTerape061().toUpperCase() + "%");
			}
			where.append(" AND t1.TERAPE_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getAnoape061() != null) {
			where.append(" AND UPPER(t1.ANOAPE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getAnoape061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getAnoape061().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOAPE_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getNumape061() != null) {
			where.append(" AND t1.NUMAPE_061 = ?");
			params.add(ab0461s00.getNumape061());
		}
		if (ab0461s00 != null && ab0461s00.getNueva061() != null) {
			where.append(" AND UPPER(t1.NUEVA_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getNueva061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getNueva061().toUpperCase() + "%");
			}
			where.append(" AND t1.NUEVA_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getTipdoc061() != null) {
			where.append(" AND UPPER(t1.TIPDOC_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getTipdoc061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getTipdoc061().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPDOC_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getNumdoc061() != null) {
			where.append(" AND UPPER(t1.NUMDOC_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getNumdoc061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getNumdoc061().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMDOC_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getNomemp061() != null) {
			where.append(" AND UPPER(t1.NOMEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getNomemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getNomemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getPaisemp061() != null) {
			where.append(" AND UPPER(t1.PAISEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getPaisemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getPaisemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.PAISEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getPrvemp061() != null) {
			where.append(" AND UPPER(t1.PRVEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getPrvemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getPrvemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.PRVEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getMunemp061() != null) {
			where.append(" AND UPPER(t1.MUNEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getMunemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getMunemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.MUNEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getDmunemp061() != null) {
			where.append(" AND UPPER(t1.DMUNEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDmunemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDmunemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.DMUNEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getDiremp061() != null) {
			where.append(" AND UPPER(t1.DIREMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDiremp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDiremp061().toUpperCase() + "%");
			}
			where.append(" AND t1.DIREMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getCpoemp061() != null) {
			where.append(" AND UPPER(t1.CPOEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getCpoemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getCpoemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.CPOEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getTlfemp061() != null) {
			where.append(" AND UPPER(t1.TLFEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getTlfemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getTlfemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.TLFEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getFaxemp061() != null) {
			where.append(" AND UPPER(t1.FAXEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getFaxemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getFaxemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getEmaemp061() != null) {
			where.append(" AND UPPER(t1.EMAEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getEmaemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getEmaemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getHttpemp061() != null) {
			where.append(" AND UPPER(t1.HTTPEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getHttpemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getHttpemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.HTTPEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getClasctr061() != null) {
			where.append(" AND UPPER(t1.CLASCTR_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getClasctr061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getClasctr061().toUpperCase() + "%");
			}
			where.append(" AND t1.CLASCTR_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getTrbtot061() != null) {
			where.append(" AND t1.TRBTOT_061 = ?");
			params.add(ab0461s00.getTrbtot061());
		}
		if (ab0461s00 != null && ab0461s00.getDeclar061() != null) {
			where.append(" AND UPPER(t1.DECLAR_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDeclar061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDeclar061().toUpperCase() + "%");
			}
			where.append(" AND t1.DECLAR_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getCardec061() != null) {
			where.append(" AND UPPER(t1.CARDEC_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getCardec061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getCardec061().toUpperCase() + "%");
			}
			where.append(" AND t1.CARDEC_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getFecevr061() != null) {
			where.append(" AND t1.FECEVR_061 = ?");
			params.add(ab0461s00.getFecevr061());
		}
		if (ab0461s00 != null && ab0461s00.getDesrie061() != null) {
			where.append(" AND UPPER(t1.DESRIE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDesrie061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDesrie061().toUpperCase() + "%");
			}
			where.append(" AND t1.DESRIE_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getDesact061() != null) {
			where.append(" AND UPPER(t1.DESACT_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDesact061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDesact061().toUpperCase() + "%");
			}
			where.append(" AND t1.DESACT_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getObserv061() != null) {
			where.append(" AND UPPER(t1.OBSERV_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getObserv061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getObserv061().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getCodctr061() != null) {
			where.append(" AND t1.CODCTR_061 = ?");
			params.add(ab0461s00.getCodctr061());
		}
		if (ab0461s00 != null && ab0461s00.getFecalt061() != null) {
			where.append(" AND t1.FECALT_061 = ?");
			params.add(ab0461s00.getFecalt061());
		}
		if (ab0461s00 != null && ab0461s00.getUsualt061() != null) {
			where.append(" AND UPPER(t1.USUALT_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getUsualt061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getUsualt061().toUpperCase() + "%");
			}
			where.append(" AND t1.USUALT_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getFecmod061() != null) {
			where.append(" AND t1.FECMOD_061 = ?");
			params.add(ab0461s00.getFecmod061());
		}
		if (ab0461s00 != null && ab0461s00.getUsumod061() != null) {
			where.append(" AND UPPER(t1.USUMOD_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getUsumod061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getUsumod061().toUpperCase() + "%");
			}
			where.append(" AND t1.USUMOD_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getDescemp061() != null) {
			where.append(" AND UPPER(t1.DESCEMP_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDescemp061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDescemp061().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCEMP_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getDoccorrecta061() != null) {
			where.append(" AND UPPER(t1.DOCCORRECTA_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getDoccorrecta061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getDoccorrecta061().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DOCCORRECTA_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getEstado061() != null) {
			where.append(" AND UPPER(t1.ESTADO_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getEstado061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getEstado061().toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADO_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getForpre061() != null) {
			where.append(" AND UPPER(t1.FORPRE_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getForpre061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getForpre061().toUpperCase() + "%");
			}
			where.append(" AND t1.FORPRE_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getMigrado061() != null) {
			where.append(" AND UPPER(t1.MIGRADO_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getMigrado061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getMigrado061().toUpperCase() + "%");
			}
			where.append(" AND t1.MIGRADO_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getFolderId061() != null) {
			where.append(" AND UPPER(t1.FOLDER_ID_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getFolderId061().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0461s00.getFolderId061().toUpperCase() + "%");
			}
			where.append(" AND t1.FOLDER_ID_061 IS NOT NULL");
		}
		if (ab0461s00 != null && ab0461s00.getCoddatosnotif061() != null) {
			where.append(
					" AND UPPER(t1.COD_DATOS_NOTIF_061) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0461s00.getCoddatosnotif061().toUpperCase() + "%");
			} else {
				params.add("%" + ab0461s00.getCoddatosnotif061().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.COD_DATOS_NOTIF_061 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Finds a single row in the Ab04b61s00 table.
	 * 
	 * folderId String Ab04b61s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os3
	 */
	@Transactional(readOnly = true)
	public OS3 findByFolderId(String folderId) {
		StringBuilder query = new StringBuilder(QUERY_SELECT);
		query.append(" FROM AB0461S00 t1 inner join  AB0477S00 t2 ");
		query.append(
				" ON t1.ANOOS3_061 = t2.ANOEXP_077 AND t1.TEROS3_061 = t2.TEREXP_077 AND t1.NUMOS3_061 = t2.NUMEXP_077 ");
		query.append(" WHERE t2.FOLDERID_077=? ");

		List<OS3> ab04b61s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, folderId);
		return (OS3) DataAccessUtils.uniqueResult(ab04b61s00List);
	}

	/**
	 * Finds a single row in the Ab04b61s00 table.
	 * 
	 * folderId String Ab04b61s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os3
	 */
	@Transactional(readOnly = true)
	public OS3 findByFolderId2(String folderId) {
		StringBuilder query = new StringBuilder(QUERY_SELECT_2);
		query.append(" FROM AB0461S00 t1 inner join  AB0477S00 t2 ");
		query.append(
				" ON t1.ANOOS3_061 = t2.ANOEXP_077 AND t1.TEROS3_061 = t2.TEREXP_077 AND t1.NUMOS3_061 = t2.NUMEXP_077 ");
		query.append(" WHERE t2.FOLDERID_077=? ");

		List<OS3> ab04b61s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMapPK, folderId);
		return (OS3) DataAccessUtils.uniqueResult(ab04b61s00List);
	}

	/**
	 * Inserts a single row in the Ab04b61s00 table.
	 * 
	 * os3 the os 3 Ab04b61s00
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 addPresencial(OS3 os3) {
		String query = "INSERT INTO AB0461S00 (ANOOS3_061, TEROS3_061, NUMOS3_061, TIPDOC_061, NUMDOC_061, NOMEMP_061, FORPRE_061, MIGRADO_061,DESEA_REG_061, NUM_REGISTRO_061, FEC_REGISTRO_061) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, os3.getAnoos3061(), os3.getTeros3061(),
				os3.getNumos3061(), os3.getTipdoc061(), os3.getNumdoc061(),
				os3.getNomemp061(), Constantes.TIPO_PRESENTACION_PRESENCIAL,
				Constantes.VALUE_NO, os3.getDeseaRegistrar061(),
				os3.getNumReg061(), os3.getFecReg061());
		return os3;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 updateFilled(OS3 os3) {
		StringBuilder query = new StringBuilder("UPDATE AB0461S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (os3 != null) {

			if (os3.getFolderId061() != null) {
				queryFields.append(", FOLDER_ID_061 = ? ");
				params.add(os3.getFolderId061());
			}

			if (os3.getFecpre061() != null) {
				queryFields.append(", FECPRE_061 = ? ");
				params.add(os3.getFecpre061());
			}

			if (os3.getEstado061() != null) {
				queryFields.append(", ESTADO_061 = ? ");
				params.add(os3.getEstado061());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?");

		params.add(os3.getTeros3061());
		params.add(os3.getAnoos3061());
		params.add(os3.getNumos3061());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return os3;
	}

	/**
	 * Finds a single row in the Ab04b61s00 table.
	 * 
	 * os3 OS3 Ab04b61s00
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	@Transactional(readOnly = true)
	public OS3 findDatosRegistro(OS3 os3) {
		StringBuilder query = new StringBuilder(
				OS3DaoImpl.QUERY_SELECT_DATOS_REGISTRO);
		query.append(" FROM AB0461S00 t1 ");
		query.append(
				" WHERE t1.ANOOS3_061 = ? AND t1.TEROS3_061 = ? AND t1.NUMOS3_061 = ? ");

		List<OS3> ab04b61s00List = this.jdbcTemplate.query(query.toString(),
				this.rwMapDatosRegistro, os3.getAnoos3061(), os3.getTeros3061(),
				os3.getNumos3061());
		return (OS3) DataAccessUtils.uniqueResult(ab04b61s00List);
	}

	/**
	 * Updates a single row in the Ab04b61s00 table.
	 * 
	 * ab04b61s00 Ab04b61s00 Ab04b61s00
	 * 
	 * @param ab04b61s00
	 *            the ab 04 b 61 s 00
	 * @return the os3
	 */
	public OS3 modificarDatosRegistro(OS3 ab04b61s00) {
		String query = "UPDATE AB0461S00 SET DESEA_REG_061=?, NUM_REGISTRO_061=?, FEC_REGISTRO_061=?  WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query, ab04b61s00.getDeseaRegistrar061(),
				ab04b61s00.getNumReg061(), ab04b61s00.getFecReg061(),
				ab04b61s00.getTeros3061(), ab04b61s00.getAnoos3061(),
				ab04b61s00.getNumos3061());
		return ab04b61s00;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.dao.OS3Dao#updateUsuariosTramitacion(com.ejie.ab04b.model
	 * .OS3)
	 */
	@Override()
	public OS3 updateUsuariosTramitacion(OS3 os3) {
		StringBuilder query = new StringBuilder("UPDATE AB0461S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (os3 != null) {

			if (os3.getUsuarioApe061() != null) {
				queryFields.append(", USUARIO_APE_061 = ? ");
				params.add(os3.getUsuarioApe061());
			}

			if (os3.getUsuarioAport061() != null) {
				queryFields.append(", USUARIO_APORT_061 = ? ");
				params.add(os3.getUsuarioAport061());
			}

			if (os3.getUsuarioTram061() != null) {
				queryFields.append(", USUARIO_TRAM_061 = ? ");
				params.add(os3.getUsuarioTram061());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}

		}

		query.append(queryFields);
		query.append(" WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?");

		params.add(os3.getTeros3061());
		params.add(os3.getAnoos3061());
		params.add(os3.getNumos3061());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return os3;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.dao.OS3Dao#updateEstado(com.ejie.ab04b.model.OS3)
	 */
	@Override
	public void updateEstado(OS3 os3) {
		String query = "UPDATE AB0461S00 SET ESTADO_061=? WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?";
		this.jdbcTemplate.update(query, os3.getEstado061(),

				os3.getTeros3061(), os3.getAnoos3061(), os3.getNumos3061());

	}

	@Override()
	public void updateBatchSub(OS3 os3) {

		StringBuilder query = new StringBuilder(
				"UPDATE AB0461S00 SET IND_BATCH_SUB_061=0");

		List<Object> params = new ArrayList<Object>();

		query.append(" WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?");

		params.add(os3.getTeros3061());
		params.add(os3.getAnoos3061());
		params.add(os3.getNumos3061());

		this.jdbcTemplate.update(query.toString(), params.toArray());
	}

	@Override
	public void updateFecSub(OS3 os3) {
		StringBuilder query = new StringBuilder("UPDATE AB0461S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (os3 != null) {

			if (os3.getFecsub061() != null) {
				queryFields.append(", FECSUB_061 = ? ");
				params.add(os3.getFecsub061());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}

		}

		query.append(queryFields);
		query.append(" WHERE TEROS3_061=? AND ANOOS3_061=? AND NUMOS3_061=?");

		params.add(os3.getTeros3061());
		params.add(os3.getAnoos3061());
		params.add(os3.getNumos3061());

		this.jdbcTemplate.update(query.toString(), params.toArray());

	}
}
